package gov.va.genisis2Test.daoImp;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateTemplate;

import gov.va.genisis2.dao.impl.UserManagementDAO;
import gov.va.genisis2.model.Users;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;

/**
 * The Class UserManagementDaoTest.
 *
 * @author1 Janet Lopez
 * 
 *          The Class UserManagementDaoTest.
 * 
 *          Description: In this UserManagementDaoTest Class which extends the
 *          abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class UserManagementDaoTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(UserManagementDaoTest.class);

	/**
	 * Test get template.
	 */
	@Test
	public void TestGetTemplate() {
		// testing for Hibernate Template
		logger.info("**********Junit Test Get Template**********");

		UserManagementDAO userManagementDao = new UserManagementDAO();
		HibernateTemplate hibernateTemplate = userManagementDao.getHibernateTemplate();
		// for coverage
		Assert.assertNull(hibernateTemplate);
		userManagementDao.setHibernateTemplate(getMockHibernateTemplate());
		hibernateTemplate = userManagementDao.getHibernateTemplate();
		Assert.assertNotNull(hibernateTemplate);

	}

	/**
	 * Test get user details by email.
	 */
	@Test
	public void TestGetUserDetailsByEmail() {

		logger.info("**********Junit Get User Details By Email**********");
		
		UserManagementDAO userManagementDao = getMockUserManagementDao();
		String email = "emailid@gmail.com";
		Users users = userManagementDao.getUserDetailsByEmail(email);
		// Assert.assertEquals("firstName", users.getFirstName());

	}

	/**
	 * Test get user role.
	 */
	@Test
	public void TestGetUserRole() {

		logger.info("**********Junit Get User Role**********");
		
		UserManagementDAO userManagementDao = getMockUserManagementDao();
		String id = "testuserid";
		// Assert.assertEquals("", role);

	}

	/**
	 * Test get user details by id.
	 */
	@Test
	public void TestGetUserDetailsById() {

		logger.info("**********Junit Get User Details By Id**********");
		
		UserManagementDAO userManagementDao = getMockUserManagementDao();
		String id = "testuserid";
		// Assert.assertEquals("firstName", users.getFirstName());

	}

}
